<?php

/**
 * Página de configuração do Portal - Suporte a Múltiplas URLs
 */

if (!defined('GLPI_ROOT')) {
   include '../../../inc/includes.php';
}

require_once __DIR__ . '/../inc/config.class.php';

// Verifica permissões
Session::checkRight('config', UPDATE);

$config_class = new PluginWbiframeConfig();


// Mensagens
$message = '';
$message_type = '';

// Processar formulários (CSRF é tratado globalmente pelo GLPI)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

   // Adicionar nova URL
   if (isset($_POST['add_url'])) {
      $new_url  = trim($_POST['new_url'] ?? '');
      $new_name = trim($_POST['new_name'] ?? '');

      if (!empty($new_url) && $config_class->isValidUrl($new_url)) {
         if ($config_class->addPortalUrl($new_url, $new_name)) {
            $message = __('URL adicionada com sucesso!', 'portal');
            $message_type = 'success';
         } else {
            $message = __('Esta URL já está configurada.', 'portal');
            $message_type = 'warning';
         }
      } else {
         $message = __('URL inválida. Insira uma URL válida.', 'portal');
         $message_type = 'error';
      }
   }

   // Remover URL
   if (isset($_POST['remove_url'])) {
      $url_to_remove = $_POST['url_to_remove'] ?? '';
      if (!empty($url_to_remove)) {
         $urls = $config_class->getPortalUrls();
         if (count($urls) > 1) { // Não permitir remover se for a única URL
            $config_class->removePortalUrl($url_to_remove);
            $message = __('URL removida com sucesso!', 'portal');
            $message_type = 'success';
         } else {
            $message = __('Não é possível remover a última URL configurada.', 'portal');
            $message_type = 'error';
         }
      }
   }

   // Definir URL ativa
   if (isset($_POST['set_active'])) {
      $active_url = $_POST['active_url'] ?? '';
      if (!empty($active_url)) {
         $config_class->setActiveUrl($active_url);
         $message = __('URL ativa alterada com sucesso!', 'portal');
         $message_type = 'success';
      }
   }

   // Atualizar nome da URL
   if (isset($_POST['update_name'])) {
      $url_to_update = $_POST['url_to_update'] ?? '';
      $new_name      = trim($_POST['new_name_update'] ?? '');

      if (!empty($url_to_update) && !empty($new_name)) {
         $urls = $config_class->getPortalUrls();
         foreach ($urls as &$url_data) {
            if ($url_data['url'] === $url_to_update) {
               $url_data['name'] = $new_name;
               break;
            }
         }
         $config_class->setPortalUrls($urls);
         $message = __('Nome da URL atualizado com sucesso!', 'portal');
         $message_type = 'success';
      }
   }
}
// Carregar URLs atuais
$portal_urls = $config_class->getPortalUrls();
$active_url = $config_class->getActivePortalUrl();

Html::header(__('Configuração do Portal', 'portal'), $_SERVER['PHP_SELF'], 'config');

echo '<div class="container-fluid">';
echo '<div class="row">';
echo '<div class="col-md-12">';

// Título
echo '<div class="card">';
echo '<div class="card-header">';
echo '<h4><i class="fas fa-globe"></i> ' . __('Configuração do Portal - Múltiplas URLs', 'portal') . '</h4>';
echo '</div>';
echo '<div class="card-body">';

// Mensagem de sucesso/erro
if (!empty($message)) {
   echo '<div class="alert alert-' . ($message_type === 'success' ? 'success' : ($message_type === 'warning' ? 'warning' : 'danger')) . '">';
   echo '<i class="fas fa-' . ($message_type === 'success' ? 'check-circle' : ($message_type === 'warning' ? 'exclamation-triangle' : 'times-circle')) . '"></i> ';
   echo $message;
   echo '</div>';
}

echo '</div>'; // card-body
echo '</div>'; // card

// Seção: URLs Configuradas
echo '<div class="card">';
echo '<div class="card-header">';
echo '<h5><i class="fas fa-list"></i> ' . __('URLs Configuradas', 'portal') . '</h5>';
echo '</div>';
echo '<div class="card-body">';

if (empty($portal_urls)) {
   echo '<div class="alert alert-info">';
   echo __('Nenhuma URL configurada. Adicione uma URL abaixo.', 'portal');
   echo '</div>';
} else {
   echo '<div class="table-responsive">';
   echo '<table class="table table-striped">';
   echo '<thead>';
   echo '<tr>';
   echo '<th>' . __('Status', 'portal') . '</th>';
   echo '<th>' . __('Nome', 'portal') . '</th>';
   echo '<th>' . __('URL', 'portal') . '</th>';
   echo '<th>' . __('Ações', 'portal') . '</th>';
   echo '</tr>';
   echo '</thead>';
   echo '<tbody>';
   
   foreach ($portal_urls as $url_data) {
      echo '<tr>';
      
      // Status (Ativa/Inativa)
      echo '<td>';
      if ($url_data['active']) {
         echo '<span class="badge badge-success"><i class="fas fa-check"></i> ' . __('Ativa', 'portal') . '</span>';
      } else {
         echo '<span class="badge badge-secondary"><i class="fas fa-times"></i> ' . __('Inativa', 'portal') . '</span>';
      }
      echo '</td>';
      
      // Nome editável
      echo '<td>';
      echo '<form method="post" style="display: inline;">';
      echo '<input type="hidden" name="_glpi_csrf_token" value="' . Session::getNewCSRFToken() . '" />';
      echo '<input type="hidden" name="url_to_update" value="' . htmlspecialchars($url_data['url']) . '" />';
      echo '<div class="input-group input-group-sm">';
      echo '<input type="text" name="new_name_update" class="form-control" value="' . htmlspecialchars($url_data['name']) . '" style="max-width: 150px;">';
      echo '<div class="input-group-append">';
      echo '<button type="submit" name="update_name" class="btn btn-outline-primary btn-sm" title="' . __('Atualizar Nome', 'portal') . '">';
      echo '<i class="fas fa-save"></i>';
      echo '</button>';
      echo '</div>';
      echo '</div>';
      echo '</form>';
      echo '</td>';
      
      // URL
      echo '<td>';
      echo '<code>' . htmlspecialchars($url_data['url']) . '</code>';
      echo '</td>';
      
      // Ações
      echo '<td>';
      echo '<div class="btn-group" role="group">';
      
      // Ativar/Desativar
      if (!$url_data['active']) {
         echo '<form method="post" style="display: inline;">';
         echo '<input type="hidden" name="_glpi_csrf_token" value="' . Session::getNewCSRFToken() . '" />';
         echo '<input type="hidden" name="active_url" value="' . htmlspecialchars($url_data['url']) . '" />';
         echo '<button type="submit" name="set_active" class="btn btn-success btn-sm" title="' . __('Ativar', 'portal') . '">';
         echo '<i class="fas fa-play"></i>';
         echo '</button>';
         echo '</form>';
      }
      
      // Remover
      if (count($portal_urls) > 1) {
         echo '<form method="post" style="display: inline;" onsubmit="return confirm(\'' . __('Tem certeza que deseja remover esta URL?', 'portal') . '\')">';
         echo '<input type="hidden" name="_glpi_csrf_token" value="' . Session::getNewCSRFToken() . '" />';
         echo '<input type="hidden" name="url_to_remove" value="' . htmlspecialchars($url_data['url']) . '" />';
         echo '<button type="submit" name="remove_url" class="btn btn-danger btn-sm" title="' . __('Remover', 'portal') . '">';
         echo '<i class="fas fa-trash"></i>';
         echo '</button>';
         echo '</form>';
      }
      
      echo '</div>';
      echo '</td>';
      
      echo '</tr>';
   }
   
   echo '</tbody>';
   echo '</table>';
   echo '</div>';
}

echo '</div>'; // card-body
echo '</div>'; // card

// Seção: Adicionar Nova URL
echo '<div class="card">';
echo '<div class="card-header">';
echo '<h5><i class="fas fa-plus"></i> ' . __('Adicionar Nova URL', 'portal') . '</h5>';
echo '</div>';
echo '<div class="card-body">';

echo '<form method="post">';
echo '<input type="hidden" name="_glpi_csrf_token" value="' . Session::getNewCSRFToken() . '" />';
echo '<div class="row">';
echo '<div class="col-md-6">';
echo '<div class="form-group">';
echo '<label for="new_url">' . __('URL do Portal:', 'portal') . '</label>';
echo '<input type="url" name="new_url" id="new_url" class="form-control" placeholder="https://exemplo.com" required>';
echo '<small class="form-text text-muted">' . __('URL completa incluindo http:// ou https://', 'portal') . '</small>';
echo '</div>';
echo '</div>';
echo '<div class="col-md-4">';
echo '<div class="form-group">';
echo '<label for="new_name">' . __('Nome (opcional):', 'portal') . '</label>';
echo '<input type="text" name="new_name" id="new_name" class="form-control" placeholder="Meu Portal">';
echo '<small class="form-text text-muted">' . __('Nome de identificação da URL', 'portal') . '</small>';
echo '</div>';
echo '</div>';
echo '<div class="col-md-2">';
echo '<div class="form-group">';
echo '<label>&nbsp;</label>';
echo '<button type="submit" name="add_url" class="btn btn-primary btn-block">';
echo '<i class="fas fa-plus"></i> ' . __('Adicionar', 'portal');
echo '</button>';
echo '</div>';
echo '</div>';
echo '</div>';
echo '</form>';

echo '</div>'; // card-body
echo '</div>'; // card

// Informações
echo '<div class="card">';
echo '<div class="card-header">';
echo '<h5><i class="fas fa-info-circle"></i> ' . __('Informações', 'portal') . '</h5>';
echo '</div>';
echo '<div class="card-body">';
echo '<p><strong>' . __('URL Ativa Atual:', 'portal') . '</strong> ';
echo '<code>' . htmlspecialchars($active_url) . '</code></p>';
echo '<div class="alert alert-info">';
echo '<i class="fas fa-lightbulb"></i> ';
echo __('<strong>Dica:</strong> Você pode configurar múltiplas URLs e alternar entre elas conforme necessário.', 'portal');
echo '</div>';
echo '<div class="alert alert-warning">';
echo '<i class="fas fa-shield-alt"></i> ';
echo __('<strong>Segurança:</strong> Para melhor segurança, use apenas URLs HTTPS.', 'portal');
echo '</div>';
echo '</div>'; // card-body
echo '</div>'; // card

echo '</div>'; // col
echo '</div>'; // row
echo '</div>'; // container-fluid

Html::footer();