<?php

/**
 * Tela principal de Integrações (visualização do portal ativo)
 */

if (!defined('GLPI_ROOT')) {
   include '../../../inc/includes.php';
}

require_once __DIR__ . '/../inc/config.class.php';

Session::checkLoginUser();

global $CFG_GLPI;

$portal_config = new PluginWbiframeConfig();
$portal_urls   = $portal_config->getPortalUrls();
$active_url    = $portal_config->getUserActivePortalUrl();
if (empty($active_url)) {
   $active_url = $CFG_GLPI['root_doc'];
}

if (Session::getCurrentInterface() == 'helpdesk') {
   Html::header(
      __('Integrações', 'portal'),
      $_SERVER['PHP_SELF'],
      'helpdesk',
      'ticket'
   );
} else {
   Html::header(__('Integrações', 'portal'), $_SERVER['PHP_SELF'], 'plugins');
}

?>
<div class="container-fluid">
   <div class="row mb-2">
      <div class="col-12 d-flex justify-content-start">
         <?php if (!empty($portal_urls)) : ?>
         <div class="btn-toolbar" role="toolbar">
            <?php foreach ($portal_urls as $url_data) : ?>
               <?php
                  $is_active = ($url_data['url'] === $active_url);
                  $label = !empty($url_data['name']) ? $url_data['name'] : $url_data['url'];
               ?>
               <div class="btn-group mr-2 mb-1" role="group">
                  <button type="button"
                          class="btn btn-sm <?php echo $is_active ? 'btn-primary' : 'btn-outline-primary'; ?>"
                          onclick="portal_set_active('<?php echo htmlspecialchars($url_data['url'], ENT_QUOTES, 'UTF-8'); ?>'); return false;">
                     <?php if ($is_active) : ?>
                        <i class="fas fa-check"></i>
                     <?php else : ?>
                        <i class="fas fa-external-link-alt"></i>
                     <?php endif; ?>
                     <?php echo htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
                  </button>
               </div>
            <?php endforeach; ?>
         </div>
         <?php endif; ?>
      </div>
   </div>

   <div class="row">
      <div class="col-12">
         <div class="card">
            <div class="card-body p-0" style="height: calc(100vh - 180px);">
               <iframe src="<?php echo htmlspecialchars($active_url, ENT_QUOTES, 'UTF-8'); ?>"
                       style="border: 0; width: 100%; height: 100%;"
                       loading="lazy"></iframe>
            </div>
         </div>
      </div>
   </div>
</div>

<script type="text/javascript">
function portal_set_active(url) {
   var form = document.createElement('form');
   form.method = 'post';
   form.action = '<?php echo $CFG_GLPI['root_doc']; ?>/plugins/wbiframe/front/switch.php';

   var token = document.createElement('input');
   token.type = 'hidden';
   token.name = '_glpi_csrf_token';
   token.value = '<?php echo Session::getNewCSRFToken(); ?>';
   form.appendChild(token);

   var active = document.createElement('input');
   active.type = 'hidden';
   active.name = 'active_url';
   active.value = url;
   form.appendChild(active);

   var flag = document.createElement('input');
   flag.type = 'hidden';
   flag.name = 'set_active';
   flag.value = '1';
   form.appendChild(flag);

   document.body.appendChild(form);
   form.submit();
}
</script>

<div class="text-center mt-3 mb-3">
   <small>
      WBiframe &mdash; Desenvolvido por <strong>WBuarque</strong> &middot;
      <a href="http://wbuarque.com.br/wbiframe" target="_blank">http://wbuarque.com.br/wbiframe</a>
   </small>
</div>

<?php
Html::footer();
