<?php

/**
 * Troca de portal ativa por usuário
 */

if (!defined('GLPI_ROOT')) {
   include '../../../inc/includes.php';
}

require_once __DIR__ . '/../inc/config.class.php';

// Garante que o usuário está logado
Session::checkLoginUser();

global $CFG_GLPI;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $active_url = $_POST['active_url'] ?? '';

   if (!empty($active_url)) {
      PluginWbiframeConfig::setUserActiveUrl($active_url, Session::getLoginUserID());
   }
}

// Redireciona de volta para a tela principal do portal
Html::redirect($CFG_GLPI['root_doc'] . '/plugins/wbiframe/front/portal.php');
