<?php

/**
 * Hooks do Plugin Portal - Suporte a Múltiplas URLs
 */

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

/**
 * Define o menu do plugin - Estrutura compatível com GLPI 11
 */
function plugin_wbiframe_getMenuContent() {
   global $CFG_GLPI;
   
   // URL base do GLPI
   $root_doc = $CFG_GLPI['root_doc'] ?? '';
   
   // Classe de configuração para obter URL ativa
   $config_class = new PluginWbiframeConfig();
   $active_url = $config_class->getUserActivePortalUrl();
   $portal_urls = $config_class->getPortalUrls();
   $is_multiple = count($portal_urls) > 1;
   
   // Estrutura de menu simplificada para GLPI 11
   $menu = [
      'title'    => __('Portal', 'portal'),
      'page'     => $root_doc . '/plugins/wbiframe/front/portal.php',
      'icon'     => 'fas fa-globe',
      'icon_img' => 'fas fa-globe',
      'shortcut' => 'portal',
      'options'  => []
   ];
   
   // Links adicionais (se suportados)
   if (isset($menu['links']) || is_array($menu)) {
      $menu['links'] = [
         'config' => $root_doc . '/plugins/wbiframe/front/config.php'
      ];
   }
   
   // Adicionar informação sobre URLs múltiplas se aplicável
   if ($is_multiple) {
      $menu['title'] .= ' (' . count($portal_urls) . ' URLs)';
   }
   
   // Adicionar URL ativa como opção
   $menu['options']['active_url'] = $active_url;
   $menu['options']['is_multiple'] = $is_multiple;

   return $menu;
}

/**
 * Função legacy para compatibilidade
 */
function plugin_wbiframe_Menu() {
   return plugin_wbiframe_getMenuContent();
}

/**
 * Função de debugging para verificar hooks
 */
function plugin_wbiframe_debug_hooks() {
   global $PLUGIN_HOOKS;
   
   // Registrar informações de debugging
   if (defined('GLPI_DEBUG') && GLPI_DEBUG) {
      error_log("Portal Plugin Hooks: " . print_r($PLUGIN_HOOKS['menu_entry'] ?? [], true));
   }
}