<?php

/**
 * Classe de menu do Plugin WBiframe.
 * Usada para exibir o item no menu (Ferramentas / Plug-ins / Helpdesk).
 */

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

class PluginWbiframeMenu extends CommonGLPI {

   /**
    * Nome exibido no menu.
    */
   public static function getMenuName() {
      return 'WBiframe';
   }

   /**
    * Conteúdo do menu para GLPI.
    */
   public static function getMenuContent() {
      global $CFG_GLPI;

      // Apenas usuários logados
      if (!Session::getLoginUserID()) {
         return [];
      }

      $menu = [];
      $menu['title'] = self::getMenuName();
      $menu['page']  = $CFG_GLPI['root_doc'] . '/plugins/wbiframe/front/portal.php';
      $menu['icon']  = 'fas fa-globe';

      return $menu;
   }

   /**
    * Itens visíveis para o usuário (fallback).
    */
   public static function getUserMenuItems() {
      $items = [];

      if (Session::getLoginUserID()) {
         $items['wbiframe']['title'] = self::getMenuName();
         $items['wbiframe']['page']  = '/plugins/wbiframe/front/portal.php';
      }

      return $items;
   }
}
