// Portal Plugin JavaScript - Múltiplas URLs
$(document).ready(function() {
    
    // Inicializar tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Validação do formulário de nova URL
    $('#new-url-form').on('submit', function(e) {
        const url = $('#new_url').val().trim();
        if (!url) {
            alert('Por favor, insira uma URL válida');
            e.preventDefault();
            return false;
        }
        
        // Validar formato da URL
        try {
            new URL(url);
        } catch (e) {
            alert('URL inválida. Por favor, insira uma URL válida (ex: https://exemplo.com)');
            e.preventDefault();
            return false;
        }
    });
    
    // Validação do formulário de configuração (legacy)
    $('#portal-config-form').on('submit', function(e) {
        const url = $('#portal_url').val().trim();
        if (!url) {
            alert('Por favor, insira uma URL válida');
            e.preventDefault();
            return false;
        }
        
        // Validar formato da URL
        try {
            new URL(url);
        } catch (e) {
            alert('URL inválida. Por favor, insira uma URL válida (ex: https://exemplo.com)');
            e.preventDefault();
            return false;
        }
    });
    
    // Confirmar remoção de URL
    $('.btn-remove-url').on('click', function(e) {
        if (!confirm('Tem certeza que deseja remover esta URL? Esta ação não pode ser desfeita.')) {
            e.preventDefault();
            return false;
        }
    });
    
    // Auto-focus no campo URL ao carregar a página
    $('#new_url').focus();
    
    // Auto-atualizar nome baseado na URL
    $('#new_url').on('blur', function() {
        const url = $(this).val();
        const nameField = $('#new_name');
        
        if (url && !nameField.val()) {
            try {
                const urlObj = new URL(url);
                const domain = urlObj.hostname;
                nameField.val(domain);
            } catch (e) {
                // URL inválida, não fazer nada
            }
        }
    });
    
    // Destacar URL ativa na tabela
    highlightActiveUrl();
    
    // Inicializar dropdown de URLs (se presente)
    initUrlDropdown();
    
    // Auto-save do nome da URL (debounce)
    let nameChangeTimeout;
    $('.url-name-input').on('change', function() {
        clearTimeout(nameChangeTimeout);
        const input = $(this);
        nameChangeTimeout = setTimeout(function() {
            // O formulário será submetido automaticamente pelo botão de salvar
        }, 1000);
    });
});

/**
 * Destacar URL ativa na tabela de URLs
 */
function highlightActiveUrl() {
    $('.portal-url-item').each(function() {
        const isActive = $(this).find('.badge-success').length > 0;
        if (isActive) {
            $(this).addClass('active fade-in');
        }
    });
}

/**
 * Inicializar dropdown de URLs
 */
function initUrlDropdown() {
    $('.dropdown-toggle').on('show.bs.dropdown', function() {
        // Animar dropdown
        $(this).next('.dropdown-menu').addClass('fade-in');
    });
}

/**
 * Confirmar alteração de URL ativa
 */
function confirmSetActive(url) {
    return confirm('Tem certeza que deseja ativar esta URL?\n\n' + url);
}

/**
 * Recarregar portal
 */
function reloadPortal() {
    location.reload();
}

/**
 * Aplicar tema escuro (se suportado)
 */
function toggleDarkMode() {
    $('body').toggleClass('dark-mode');
    localStorage.setItem('portal-dark-mode', $('body').hasClass('dark-mode'));
}

/**
 * Carregar preferência de tema
 */
function loadThemePreference() {
    const isDark = localStorage.getItem('portal-dark-mode') === 'true';
    if (isDark) {
        $('body').addClass('dark-mode');
    }
}

// Aplicar tema ao carregar
loadThemePreference();

/**
 * Validação de URL em tempo real
 */
function validateUrlField(input) {
    const url = $(input).val();
    const isValid = isValidUrl(url);
    
    if (isValid) {
        $(input).removeClass('is-invalid').addClass('is-valid');
    } else if (url) {
        $(input).removeClass('is-valid').addClass('is-invalid');
    } else {
        $(input).removeClass('is-valid is-invalid');
    }
}

/**
 * Função auxiliar para validar URL
 */
function isValidUrl(url) {
    if (!url) return false;
    
    try {
        new URL(url);
        return true;
    } catch (e) {
        return false;
    }
}

/**
 * Detectar mudança de URL ativa via JavaScript
 */
function detectActiveUrlChange() {
    // Observar mudanças no DOM para detectar mudanças de URL ativa
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'childList') {
                highlightActiveUrl();
            }
        });
    });
    
    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
}

// Inicializar detector de mudanças
detectActiveUrlChange();