<?php

/**
 * Plugin Portal - GLPI 11 (Múltiplas URLs)
 * Plugin para exibir portal externo no menu lateral com suporte a múltiplas URLs
 */

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

// Versão do plugin
define('PLUGIN_WBIFRAME_VERSION', '2.0.0');

/**
 * Função de inicialização do plugin
 */
function plugin_init_wbiframe() {
   global $PLUGIN_HOOKS;

   // Hooks necessários para GLPI 11
   $PLUGIN_HOOKS['csrf_compliant']['wbiframe'] = true;

   // Entrada em Ferramentas via classe de menu (compatível GLPI 10/11/12)
   $PLUGIN_HOOKS['menu_toadd']['wbiframe'] = [
      'tools'    => 'PluginWbiframeMenu',
      'helpdesk' => 'PluginWbiframeMenu',
   ];

   // Entrada na interface simplificada (Self-Service)
   // Caminho relativo a partir da raiz do GLPI
   $PLUGIN_HOOKS['helpdesk_menu_entry']['wbiframe'] =
      '/plugins/wbiframe/front/portal.php';

   // Registra classe de menu para o autoloader do GLPI
   if (class_exists('Plugin')) {
      Plugin::registerClass('PluginWbiframeMenu');
   }

   // Hook para páginas do plugin
   $PLUGIN_HOOKS['plugin_pages']['wbiframe'] = ['portal.php', 'config.php'];
   
   // Hook para conteúdo do menu (ESSENCIAL para GLPI 11)
   $PLUGIN_HOOKS['menu_content']['wbiframe'] = 'plugin_wbiframe_getMenuContent';
   
   // Página de configuração
   $PLUGIN_HOOKS['config_page']['wbiframe'] = 'front/config.php';
   
   // Hook adicional para compatibilidade
   $PLUGIN_HOOKS['add_css']['wbiframe'][] = 'portal.css';
   $PLUGIN_HOOKS['add_javascript']['wbiframe'][] = 'portal.js';
}

/**
 * Informações da versão do plugin
 */
function plugin_version_wbiframe() {
   return [
      'name'           => 'WBiframe',
      'version'        => PLUGIN_WBIFRAME_VERSION,
      'author'         => 'WBuarque',
      'license'        => 'GPLv2+',
      'homepage'       => 'https://wbuarque.com.br',
      'logo'           => Plugin::getWebDir('wbiframe') . '/pics/logo_p11.png',
      'minGlpiVersion' => '11.0.0',
   ];
}

/**
 * Verifica pré-requisitos
 */
function plugin_wbiframe_check_prerequisites() {
   if (version_compare(GLPI_VERSION, '11.0.0', '<')) {
      return "GLPI 11.0.0 ou superior é necessário";
   }
   return true;
}

/**
 * Verifica configuração
 */
function plugin_wbiframe_check_config($verbose = false) {
   return true;
}

/**
 * Instala o plugin
 */
function plugin_wbiframe_install() {
   return true;
}

/**
 * Desinstala o plugin
 */
function plugin_wbiframe_uninstall() {
   return true;
}

/**
 * Função adicional de versão para compatibilidade
 */
function plugin_version_custom() {
   return plugin_version_wbiframe();
}