<?php
/**
 * WB Store - Install page
 */
include ("../../../inc/includes.php");

// Guard lives in /inc (not covered by the simple PSR-4 autoloader in setup.php)
require_once __DIR__ . "/../inc/guard.php";

// Simple HTML escaper for GLPI 10
function wbstore_e($v) {
   return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

use GlpiPlugin\Wbstore\Config;
use GlpiPlugin\Wbstore\StoreClient;
use GlpiPlugin\Wbstore\PluginInstaller;
use GlpiPlugin\Wbstore\Webhook;
use GlpiPlugin\Wbstore\Utils;
use GlpiPlugin\Wbstore\Guard;

Session::checkRight('config', UPDATE);

// Garante portal_token e tenta sincronizar cache/licença (best-effort)
Utils::ensurePortalToken();
try { Guard::refreshPackagesCache(false); } catch (\Throwable $e) {}

$slug = trim((string)($_GET['slug'] ?? ''));
if ($slug === '') {
   Html::displayErrorAndDie('Slug inválido.');
}

Html::header('WB Store - Instalar', $_SERVER['PHP_SELF'], 'config', 'plugins');
echo "<div class='center' style='max-width:1100px;margin:0 auto'>";
echo "<h2 style='margin:0 0 12px'>Instalar pacote: <code>" . wbstore_e($slug) . "</code></h2>";


// ===== Avisos WBUARQUE (iframe) =====
$iframe = Utils::portalNoticesIframeUrl(['embed' => 'install', 'slug' => $slug]);
if ($iframe !== '') {
   echo "<div style='margin:12px 0 14px'>";
   echo "<div style='display:flex;align-items:center;justify-content:space-between;gap:10px;flex-wrap:wrap'>";
   echo "<div style='font-weight:900'><i class='fas fa-bell' style='color:#15803d'></i> Avisos WBUARQUE</div>";
   echo "<a class='btn btn-secondary' href='notifications.php'><i class='fas fa-inbox'></i> Ver avisos</a>";
   echo "</div>";
   echo "<div style='margin-top:10px;border:1px solid rgba(16,24,40,.12);border-radius:16px;overflow:hidden;background:#f8fafc'>";
   echo "<iframe src='" . wbstore_e($iframe) . "' style='width:100%;height:220px;border:0' loading='lazy'></iframe>";
   echo "</div>";
   echo "</div>";
}

if (!Config::isConfigured()) {
   echo "<div class='alert alert-danger'>WB Store não está configurado. Vá em Configurações e libere o acesso.</div>";
   echo "<a class='btn btn-secondary' href='config.php'>Voltar</a>";
   echo "</div>";
   Html::footer();
   exit;
}

$client = new StoreClient();

// Não bloqueie o WBStore por “licença não validada” (POST pode ser bloqueado por WAF).
// Quem manda é o Portal: cada pacote vem com can_download.
$pkg = $client->getPackage($slug);
$can = null;
if (is_array($pkg) && array_key_exists('can_download', $pkg)) {
   $can = (bool)$pkg['can_download'];
}

// Fallback: tenta encontrar o pacote na lista
if ($can === null) {
   $list = $client->listPackages();
   $items = [];
   if (isset($list['packages']) && is_array($list['packages'])) {
      $items = $list['packages'];
   } elseif (is_array($list)) {
      $items = $list;
   }
   foreach (($items ?: []) as $it) {
      if (!is_array($it)) continue;
      if ((string)($it['slug'] ?? '') === $slug && array_key_exists('can_download', $it)) {
         $can = (bool)$it['can_download'];
         break;
      }
   }
}

if ($can === false) {
   echo "<div class='alert alert-danger'>Este pacote não está liberado para sua licença/plano.</div>";
   echo "<div style='display:flex;gap:10px;flex-wrap:wrap'>";
   echo "<a class='btn btn-secondary' href='catalog.php'><i class='fas fa-arrow-left'></i> Voltar</a>";
   echo "<a class='btn btn-primary' target='_blank' rel='noopener' href='https://site.wbuarque.com.br'><i class='fas fa-handshake'></i> Contratar</a>";
   echo "</div>";
   echo "</div>";
   Html::footer();
   exit;
}

Webhook::event('wbstore.download.start', ['slug'=>$slug]);
$res = $client->downloadPackage($slug);
if (!isset($res['error'])) { Webhook::event('wbstore.download.ok', ['slug'=>$slug,'sha256'=>($res['sha256']??''),'meta'=>($res['meta']??[])]); } else { Webhook::event('wbstore.download.fail', ['slug'=>$slug,'error'=>$res['error']]); }

if (isset($res['error'])) {
   echo "<div class='alert alert-danger'>" . wbstore_e($res['error']) . "</div>";
   echo "<a class='btn btn-secondary' href='catalog.php'>Voltar</a>";
   echo "</div>";
   Html::footer();
   exit;
}

$tmp = $res['tmp'];
$meta = $res['meta'];

$installer = new PluginInstaller();
$ok = $installer->installFromZip($tmp, $meta);

// Cleanup tmp zip
@unlink($tmp);

if (!$ok['ok']) {
   echo "<div class='alert alert-danger'>" . wbstore_e($ok['msg']) . "</div>";
   echo "<a class='btn btn-secondary' href='catalog.php'>Voltar</a>";
   echo "</div>";
   Html::footer();
   exit;
}

Webhook::event('wbstore.install.ok', ['slug'=>$slug,'result'=>$ok]);

echo "<div class='alert alert-success'>" . wbstore_e($ok['msg']) . "</div>";

$safe = (int)Config::get('safe_mode', 1);
if ($safe) {
   echo "<p><b>Modo seguro:</b> o plugin foi <b>instalado</b>, mas <b>não foi ativado</b> automaticamente.</p>";
   echo "<p>Agora vá em <b>Configurar → Plug-ins</b> e clique em <b>Ativar</b> no plugin instalado.</p>";
} else {
   echo "<p><b>Obs:</b> a ativação automática não é implementada aqui de propósito (evita dar ruim em produção). Ative manualmente no GLPI.</p>";
}

echo "<div style='display:flex;gap:10px;margin-top:12px'>";
echo "<a class='btn btn-secondary' href='catalog.php'><i class='fas fa-arrow-left'></i> Voltar ao catálogo</a>";
echo "<a class='btn btn-primary' href='" . $CFG_GLPI['root_doc'] . "/front/plugin.php'><i class='fas fa-plug'></i> Ir para Plug-ins</a>";
echo "</div>";

echo "</div>";
Html::footer();
