<?php
include ("../../../inc/includes.php");

// Guard lives in /inc (not covered by the simple PSR-4 autoloader in setup.php)
require_once __DIR__ . "/../inc/guard.php";

use GlpiPlugin\Wbstore\Config;
use GlpiPlugin\Wbstore\Notifications;
use GlpiPlugin\Wbstore\Utils;

Session::checkRight('config', UPDATE);

Html::header('WB Store - Avisos', $_SERVER['PHP_SELF'], 'config', 'plugins');

$csrf = Session::getNewCSRFToken();

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
   if (isset($_POST['mark_read']) && isset($_POST['id'])) {
      Notifications::markRead((int)$_POST['id']);
   }
   if (isset($_POST['clear_read'])) {
      Notifications::clearRead();
   }
   Html::redirect(Plugin::getWebDir('wbstore') . '/front/notifications.php');
   exit;
}

echo "<div class='center' style='max-width:1100px;margin:0 auto'>";
echo "<h2 style='margin:0 0 12px'>Avisos WBUARQUE</h2>";
echo "<p style='opacity:.8;margin:0 0 12px'>Área de avisos carregada pelo catálogo.</p>";

echo "<div style='display:flex;gap:10px;flex-wrap:wrap;margin:0 0 12px'>";
echo "<a class='btn btn-primary' href='".Plugin::getWebDir('wbstore')."/front/config.php'><i class='fas fa-store'></i> Voltar</a>";
echo "</div>";

$iframe = Utils::portalNoticesIframeUrl(['embed' => 'notifications']);
if ($iframe === '') {
   echo "<div class='alert alert-warning'>Avisos indisponíveis (store_url não configurada).</div>";
} else {
   echo "<div style='border:1px solid rgba(16,24,40,.12);border-radius:16px;overflow:hidden;background:#f8fafc'>";
   echo "<iframe src='".htmlspecialchars($iframe, ENT_QUOTES, 'UTF-8')."' style='width:100%;height:70vh;border:0' loading='lazy'></iframe>";
   echo "</div>";
   echo "<div style='opacity:.75;font-size:12px;margin-top:8px'>Se não carregar, a Store precisa permitir iframe (headers de segurança).</div>";
}

echo "</div>";
Html::footer();
