<?php
/**
 * WB Store - install/uninstall hooks
 */
if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

use GlpiPlugin\Wbstore\Installer;

function plugin_wbstore_install() {
   $installer = new Installer();
   return $installer->install();
}

function plugin_wbstore_uninstall() {
   if (class_exists('CronTask')) {
      CronTask::Unregister('wbstore');
      try { CronTask::Unregister('PluginWbstoreCron'); } catch (Throwable $e) {}
   }

   $installer = new Installer();
   return $installer->uninstall();
}

/**
 * Menu provider (mostra ícone no menu esquerdo, como outros plugins).
 */
class PluginWbstoreMenu extends CommonGLPI {

   static function getMenuName() {
      return __('WB Store', 'wbstore');
   }

   static function getIcon() {
      // Font Awesome icon (GLPI 10)
      return 'fas fa-store';
   }

   static function getMenuContent() {
      $webdir = Plugin::getWebDir('wbstore');
      return [
         'title' => __('WB Store', 'wbstore'),
         'page'  => $webdir . '/front/catalog.php',
         'icon'  => self::getIcon()
      ];
   }
}