<?php
// WBSTORE SDK helper (global wrappers for older WB plugins)
if (!defined('GLPI_ROOT')) { die("Sorry. You can't access this file directly"); }

require_once __DIR__ . '/guard.php';

use GlpiPlugin\Wbstore\Guard;

/**
 * Retorna true se o plugin (slug) está liberado pela WBSTORE (cache local).
 * NÃO faz HTTP remoto.
 */
function wbstore_is_allowed(string $slug): bool {
   return Guard::isPluginAllowedMonthly($slug, false);
}

/**
 * Força sincronização online (deve ser usado apenas em tela de catálogo/config).
 */
function wbstore_force_sync(): bool {
   return Guard::refreshPackagesCache(true);
}
