<?php
/**
 * WB Store - Private plugin store / installer for GLPI 10
 * (c) Wellington Buarque - wbuarque.com.br
 */
if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

// Simple PSR-4-ish autoloader for our namespace (no composer required).
spl_autoload_register(function ($class) {
   $prefix = 'GlpiPlugin\\Wbstore\\';
   $base_dir = __DIR__ . '/src/';
   if (strpos($class, $prefix) !== 0) {
      return;
   }
   $relative = substr($class, strlen($prefix));
   $file = $base_dir . str_replace('\\', '/', $relative) . '.php';
   if (is_file($file)) {
      require_once $file;
   }
});

function plugin_version_wbstore() {
   return [
      'name'           => 'WB Store',
      'version'        => '1.3.8',
      'author'         => 'WBUARQUE',
      'license'        => 'GPLv2+',
      'homepage'       => 'https://wbuarque.com.br',
      // Igual ao Conecta Turbo: capa/local no root do plugin
      'logo'           => 'plugin-icon2.png',
      'icon'           => 'fas fa-store',
      'minGlpiVersion' => '10.0.0'
   ];
}

function plugin_wbstore_check_prerequisites() {
   if (version_compare(GLPI_VERSION, '10.0.0', '<')) {
      echo "WB Store requires GLPI 10.0.0 or higher.";
      return false;
   }
   if (!class_exists('ZipArchive')) {
      echo "WB Store requires PHP ZipArchive extension.";
      return false;
   }
   return true;
}

function plugin_wbstore_check_config($verbose = false) {
   // Plugin works even without configuration; it will just block installs until configured.
   return true;
}

function plugin_init_wbstore() {
   global $PLUGIN_HOOKS;

   // Ensure cron task class is available when CronTask runs / UI lists it
   if (is_file(__DIR__ . '/inc/cron.class.php')) {
      require_once __DIR__ . '/inc/cron.class.php';
   }

   $PLUGIN_HOOKS['csrf_compliant']['wbstore'] = true;

   // Ícone do menu (GLPI 10 - Font Awesome)
   $PLUGIN_HOOKS['menu_entry_icon']['wbstore'] = 'fas fa-store';
   // Configuration entry (wrench link in plugins list)
   $PLUGIN_HOOKS['config_page']['wbstore'] = 'front/config.php';

   // Menu lateral (Configurar) - igual aos plugins do GLPI (classe em hook.php)
   if (Session::haveRight('config', UPDATE)) {
      $PLUGIN_HOOKS['menu_toadd']['wbstore'] = ['config' => 'PluginWbstoreMenu'];
   }

   // Add menu in Setup (config) - GLPI 10 espera um nome de classe aqui
   if (Session::haveRight('config', UPDATE)) {
   }
}