<?php
namespace GlpiPlugin\Wbstore;

use Config as GlpiConfig;

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

class Config {

   public static function context(): string {
      return 'plugin:wbstore';
   }

   public static function get(string $key, $default = null) {
      $vals = GlpiConfig::getConfigurationValues(self::context(), [$key]);
      if (!array_key_exists($key, $vals) || $vals[$key] === null) {
         return $default;
      }
      return $vals[$key];
   }

   public static function set(array $values): void {
      GlpiConfig::setConfigurationValues(self::context(), $values);
   }

   public static function all(): array {
      return GlpiConfig::getConfigurationValues(self::context());
   }

   public static function isConfigured(): bool {
      $api = self::get('api_base', '');
      $lic = self::get('license_key', '');
      return (is_string($api) && trim($api) !== '') && (is_string($lic) && trim($lic) !== '');
   }
}
