<?php
namespace GlpiPlugin\Wbstore;

if (!defined('GLPI_ROOT')) {
   die("Sorry. You can't access this file directly");
}

/**
 * Menu provider for WB Store (GLPI 10).
 */
class Menu {

   public static function getMenuName($nb = 0) {
      return __('WB Store', 'wbstore');
   }

   public static function getMenuContent() {
      // GLPI 10 routes plugin resources via /plugins/<key>/... mesmo se instalado do marketplace
      $catalog = '/plugins/wbstore/front/catalog.php';
      $config  = '/plugins/wbstore/front/config.php';

      return [
         'title' => __('WB Store', 'wbstore'),
         'icon'  => 'fas fa-store',
         'page'  => $catalog,
         'options' => [
            'catalog' => [
               'title' => __('Catálogo', 'wbstore'),
               'page'  => $catalog,
               'links' => [
                  'search' => $catalog
               ]
            ],
            'config' => [
               'title' => __('Configuração', 'wbstore'),
               'page'  => $config,
               'links' => [
                  'search' => $config
               ]
            ],
         ]
      ];
   }
}
